﻿<%@ Page Title="Patient Image Details" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="PatientImageDetails.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.PatientImageDetails" %>

<asp:Content ID="ContentHead" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>

<asp:Content ID="ContentMain" ContentPlaceHolderID="MainContent" Runat="Server">

    <link href="<%: ResolveUrl("~/Content/Custom/EFR/AccessibleForm.css") %>" rel="stylesheet" />

    <script type ="text/javascript">

        $(document).ready(function () {

            // *************************************************************************************
            //      Check initial state
            // *************************************************************************************
            var otherImageTypeSelected = $('#<%=Radio_STD_IMAGE_TYPE_O.ClientID%>:checked').val();
            if (otherImageTypeSelected === 'Radio_STD_IMAGE_TYPE_O') {
                $('#<%=TextBoxOtherImageType.ClientID%>').prop('disabled', false);
            } else {
                $('#<%=TextBoxOtherImageType.ClientID%>').prop('disabled', true);
                $('#<%=TextBoxOtherImageType.ClientID%>').val('');
            }
            if ($('#<%=CheckBox_STD_IMAGE_REASON_O.ClientID %>').is(":checked")) {
                $('#<%=TextBoxOtherImageReason.ClientID%>').prop('disabled', false);
            } else {
                $('#<%=TextBoxOtherImageReason.ClientID%>').prop('disabled', true);
                $('#<%=TextBoxOtherImageReason.ClientID%>').val('');
            }

            // *************************************************************************************
            //      Key Handlers: No postbacks except for buttons
            // *************************************************************************************
            var nav = window.Event ? true : false;
            if (nav) {
                window.captureEvents(Event.KEYDOWN);
                window.onkeydown = NetscapeEventHandler_KeyDown;
            } else {
                document.onkeydown = MicrosoftEventHandler_KeyDown;
            }
            function NetscapeEventHandler_KeyDown(e) {
                if (e.which == 13 && e.target.type != 'textarea' && e.target.type != 'submit') {
                    return false;
                }
                return true;
            }
            function MicrosoftEventHandler_KeyDown() {
                if (event.keyCode == 13 && event.srcElement.type != 'textarea' &&
                event.srcElement.type != 'submit')
                    return false;
                return true;
            }

            // *************************************************************************************
            //      PanelImageType Change Event
            // *************************************************************************************
            $('#<%=PanelImageType.ClientID %> input').change(function () {

                var otherImageTypeSelected = (this).value;
                if (otherImageTypeSelected === 'Radio_STD_IMAGE_TYPE_O') {
                    $('#<%=TextBoxOtherImageType.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=TextBoxOtherImageType.ClientID%>').prop('disabled', true);
                    $('#<%=TextBoxOtherImageType.ClientID%>').val('');
                }
            });

            // *************************************************************************************
            //      CheckBox_STD_IMAGE_REASON_O Change Event
            // *************************************************************************************
            $('#<%=CheckBox_STD_IMAGE_REASON_O.ClientID %>').on('change', function () {

                if ($('#<%=CheckBox_STD_IMAGE_REASON_O.ClientID %>').is(":checked")) {
                    $('#<%=TextBoxOtherImageReason.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=TextBoxOtherImageReason.ClientID%>').prop('disabled', true);
                    $('#<%=TextBoxOtherImageReason.ClientID%>').val('');
                }
            });

            // *************************************************************************************
            //      DropDownListReviewed Change Event
            // *************************************************************************************
            $('#<%=DropDownListReviewed.ClientID %>').on('change', function () {

                checkSaveRules();
            });

            // *************************************************************************************
            //      DropDownListIncludeInReport Change Event
            // *************************************************************************************
            $('#<%=DropDownListIncludeInReport.ClientID %>').on('change', function () {

                checkSaveRules();
            });

            // *************************************************************************************
            //      PanelFragmentDimensions Change Event: check entries for numbers
            // *************************************************************************************
            $('#<%=PanelFragmentDimensions.ClientID %> input').change(function () {

                var toolTip = 'Save Entries.';

                var dimension = (this).value;
                if (!$.isNumeric(dimension)) {
                    $('#<%=ButtonSave.ClientID%>').prop('disabled', true);
                    toolTip = 'Value for dimension must be a number.';
                } else {
                    $('#<%=ButtonSave.ClientID%>').prop('disabled', false);
                }

                $('#<%=ButtonSave.ClientID%>').prop('title', toolTip); 
            });

        }); // $(document).ready(function ()

        // *************************************************************************************
        //      checkSaveRules: Include in report is mandatory if Reviewed on this page 
        //                      is checked “yes”
        // *************************************************************************************
        var checkSaveRules = function () {

            var include = $("#<%=DropDownListIncludeInReport.ClientID %> option:selected").val();
            var reviewed = $("#<%=DropDownListReviewed.ClientID %> option:selected").val();

            var toolTip = 'Save Entries.';

            if (reviewed === 'true') {
                    
                if (include === 'true' || include === 'false') {
                    $('#<%=ButtonSave.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=ButtonSave.ClientID%>').prop('disabled', true);
                    toolTip = 'Include in Report is Required.';
                }
            } else {
                $('#<%=ButtonSave.ClientID%>').prop('disabled', false);
            }

            $('#<%=ButtonSave.ClientID%>').prop('title', toolTip); 
        }

    </script>

    <!-- ********************************************************************************************** -->
    <!-- Patient Information -->
    <!-- ******************* -->
    <asp:Panel ID="PanelPatientInformation" runat="server" GroupingText="&nbsp;&nbsp;Patient Information&nbsp;&nbsp;" Width="100%">
        <div class="summary-content">
            <div class="lc2">
                <asp:Label ID="LabelPatientName" runat="server" Text="Patient Name:&nbsp;&nbsp;" />
            </div>
            <div class="rc2">
                <asp:Label ID="LabelPatientSsn" runat="server" Text="Patient SSN:&nbsp;&nbsp;" />
            </div>
            <div class="lc2">
                <asp:Label ID="LabelSystemIDFragment" runat="server" Text="System Identified Fragment:&nbsp;&nbsp;" />
            </div>
            <div class="rc2">
                <asp:Label ID="LabelStudyDescription" runat="server" Text="Study Description:&nbsp;&nbsp;" />
            </div>
        </div>
    </asp:Panel>

    <br />
    <br />
    
    <div class="clear-float"></div>

    <br />
    <br />
    
    <div id="accessible-form">

        <div id="imageSummaryContainer">

            <asp:Panel ID="PanelImageType" runat="server" GroupingText="&nbsp;&nbsp;Image Type&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="left-float"><input type="radio" runat="server" name="imageTypes" id="Radio_STD_IMAGE_TYPE_XR" /><label for="Radio_STD_IMAGE_TYPE_XR" id="Label_STD_IMAGE_TYPE_XR">X-Ray</label></div>
                <div class="left-float"><input type="radio" runat="server" name="imageTypes" id="Radio_STD_IMAGE_TYPE_CT" /><label for="Radio_STD_IMAGE_TYPE_CT" id="Label_STD_IMAGE_TYPE_CT">CT Scan</label></div>
                <div class="left-float"><input type="radio" runat="server" name="imageTypes" id="Radio_STD_IMAGE_TYPE_O" /><label for="Radio_STD_IMAGE_TYPE_O" id="Label_STD_IMAGE_TYPE_O">Other</label></div>
                <div class="clear-float"></div>
                <asp:Label ID="LabelOtherImageType" runat="server" Text="Other Image Type:" AssociatedControlID="TextBoxOtherImageType" />
                <asp:TextBox runat="server"  ID="TextBoxOtherImageType" ToolTip="Enter Other Image Type" Width="500" />
            </asp:Panel>

            <div class="clear-float"></div>
            <br />
            <br />

            <asp:Panel ID="PanelImageReasons" runat="server" GroupingText="&nbsp;&nbsp;Reasons For Imaging&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_C" /><label for="CheckBox_STD_IMAGE_REASON_C" id="Label_STD_IMAGE_REASON_C">Confirm Presence of Fragment</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_R" /><label for="CheckBox_STD_IMAGE_REASON_R" id="Label_STD_IMAGE_REASON_R">Routine Follow-up of Fragment</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_P" /><label for="CheckBox_STD_IMAGE_REASON_P" id="Label_STD_IMAGE_REASON_P">Pain Possibly r/t Fragment</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_I" /><label for="CheckBox_STD_IMAGE_REASON_I" id="Label_STD_IMAGE_REASON_I">Inflammation Possibly r/t Fragment</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_N" /><label for="CheckBox_STD_IMAGE_REASON_N" id="Label_STD_IMAGE_REASON_N">Imaging Initially Performed for Non-fragment Related Reason</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_REASON_O" /><label for="CheckBox_STD_IMAGE_REASON_O" id="Label_STD_IMAGE_REASON_O">Other Symptom r/t Fragment (specify)</label></div>
                <div class="clear-float"></div>
                <asp:Label ID="LabelOtherImageReason" runat="server" Text="Other Image Reason:" AssociatedControlID="TextBoxOtherImageReason" />
                <asp:TextBox runat="server"  ID="TextBoxOtherImageReason" ToolTip="Enter Other Image Reason" Width="500" />
            </asp:Panel>

            <div class="clear-float"></div>
            <br />
            <br />

            <asp:Panel ID="PanelBodyParts" runat="server" GroupingText="&nbsp;&nbsp;Body Parts Imaged&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_H" /><label for="CheckBox_STD_IMAGE_BODY_PART_H" id="Label_STD_IMAGE_BODY_PART_H">Head</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_C" /><label for="CheckBox_STD_IMAGE_BODY_PART_C" id="Label_STD_IMAGE_BODY_PART_C">Chest</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_UB" /><label for="CheckBox_STD_IMAGE_BODY_PART_UB" id="Label_STD_IMAGE_BODY_PART_UB">Upper Back</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_GR" /><label for="CheckBox_STD_IMAGE_BODY_PART_GR" id="Label_STD_IMAGE_BODY_PART_GR">Groin/Pelvis</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LS" /><label for="CheckBox_STD_IMAGE_BODY_PART_LS" id="Label_STD_IMAGE_BODY_PART_LS">Left Shoulder</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RS" /><label for="CheckBox_STD_IMAGE_BODY_PART_RS" id="Label_STD_IMAGE_BODY_PART_RS">Right Shoulder</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LUA" /><label for="CheckBox_STD_IMAGE_BODY_PART_LUA" id="Label_STD_IMAGE_BODY_PART_LUA">Left Upper Arm</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RUA" /><label for="CheckBox_STD_IMAGE_BODY_PART_RUA" id="Label_STD_IMAGE_BODY_PART_RUA">Right Upper Arm</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LUT" /><label for="CheckBox_STD_IMAGE_BODY_PART_LUT" id="Label_STD_IMAGE_BODY_PART_LUT">Left Upper Thigh/Leg</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RUT" /><label for="CheckBox_STD_IMAGE_BODY_PART_RUT" id="Label_STD_IMAGE_BODY_PART_RUT">Right Upper Thigh/Leg</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LA" /><label for="CheckBox_STD_IMAGE_BODY_PART_LA" id="Label_STD_IMAGE_BODY_PART_LA">Left Ankle</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RA" /><label for="CheckBox_STD_IMAGE_BODY_PART_RA" id="Label_STD_IMAGE_BODY_PART_RA">Right Ankle</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_N" /><label for="CheckBox_STD_IMAGE_BODY_PART_N" id="Label_STD_IMAGE_BODY_PART_N">Neck</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_AB" /><label for="CheckBox_STD_IMAGE_BODY_PART_AB" id="Label_STD_IMAGE_BODY_PART_AB">Abdomen</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LB" /><label for="CheckBox_STD_IMAGE_BODY_PART_LB" id="Label_STD_IMAGE_BODY_PART_LB">Lower Back</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_BUT" /><label for="CheckBox_STD_IMAGE_BODY_PART_BUT" id="Label_STD_IMAGE_BODY_PART_BUT">Buttocks</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LH" /><label for="CheckBox_STD_IMAGE_BODY_PART_LH" id="Label_STD_IMAGE_BODY_PART_LH">Left Hand, Wrist, or Fingers</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RH" /><label for="CheckBox_STD_IMAGE_BODY_PART_RH" id="Label_STD_IMAGE_BODY_PART_RH">Right Hand, Wrist, or Fingers</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LLA" /><label for="CheckBox_STD_IMAGE_BODY_PART_LLA" id="Label_STD_IMAGE_BODY_PART_LLA">Left Lower Arm</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RLA" /><label for="CheckBox_STD_IMAGE_BODY_PART_RLA" id="Label_STD_IMAGE_BODY_PART_RLA">Right Lower Arm</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LK" /><label for="CheckBox_STD_IMAGE_BODY_PART_LK" id="Label_STD_IMAGE_BODY_PART_LK">Left Knee</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RK" /><label for="CheckBox_STD_IMAGE_BODY_PART_RK" id="Label_STD_IMAGE_BODY_PART_RK">Right Knee</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_LF" /><label for="CheckBox_STD_IMAGE_BODY_PART_LF" id="Label_STD_IMAGE_BODY_PART_LF">Left Foot/Toes</label></div>
                <div class="left-float"><input type="checkbox" runat="server" id="CheckBox_STD_IMAGE_BODY_PART_RF" /><label for="CheckBox_STD_IMAGE_BODY_PART_RF" id="Label_STD_IMAGE_BODY_PART_RF">Right Foot/Toes</label></div>
            </asp:Panel>

            <div class="clear-float"></div>
            <br />
            <br />

            <asp:Panel ID="PanelFragmentCount" runat="server" GroupingText="&nbsp;&nbsp;Number of Fragments&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="left-float"><input type="radio" name="fragmentCounts" runat="server" id="Radio_STD_IMAGE_FRAGMENT_COUNT_1" /><label for="Radio_IMAGE_FRAGMENT_COUNT_1" id="Label_STD_IMAGE_TYPE_1">1</label></div>
                <div class="left-float"><input type="radio" name="fragmentCounts" runat="server" id="Radio_STD_IMAGE_FRAGMENT_COUNT_2_5" /><label for="Radio_IMAGE_FRAGMENT_COUNT_2_5" id="Label_STD_IMAGE_TYPE_2_5">Between 2 and 5</label></div>
                <div class="left-float"><input type="radio" name="fragmentCounts" runat="server" id="Radio_STD_IMAGE_FRAGMENT_COUNT_6_10" /><label for="Radio_IMAGE_FRAGMENT_COUNT_6_10" id="Label_STD_IMAGE_TYPE_6_10">Between 6 and 10</label></div>
                <div class="left-float"><input type="radio" name="fragmentCounts" runat="server" id="Radio_STD_IMAGE_FRAGMENT_COUNT_11_19" /><label for="Radio_IMAGE_FRAGMENT_COUNT_11_19" id="Label_STD_IMAGE_TYPE_11_19">Between 11 and 19</label></div>
                <div class="left-float"><input type="radio" name="fragmentCounts" runat="server" id="Radio_STD_IMAGE_FRAGMENT_COUNT_20" /><label for="Radio_IMAGE_FRAGMENT_COUNT_20" id="Label_STD_IMAGE_TYPE_20">20 or more</label></div>
            </asp:Panel>

            <div class="clear-float"></div>
            <br />
            <br />

            <asp:Panel ID="PanelFragmentDimensions" runat="server" GroupingText="&nbsp;&nbsp;Fragment Dimensions&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="two-columns">
                    <div class="lc2">
                        <label for="TextBoxLargestFragmentLength" id="LabelLargestFragmentLength">Largest Fragment Length (mm):</label>
                        <input type="text" name="Largest_Length" runat="server" id="TextBoxLargestFragmentLength" />
                    </div>
                    <div class="rc2">
                        <label for="TextBoxLargestFragmentWidth" id="LabelLargestFragmentWidth">Largest Fragment Width (mm):</label>
                        <input type="text" name="Largest_Width" runat="server" id="TextBoxLargestFragmentWidth" />
                    </div>
                    <br />
                    <br />
                    <div class="lc2">
                        <label for="TextBoxSmallestFragmentLength" id="LabelSmallestFragmentLength">Smallest Fragment Length (mm):</label>
                        <input type="text" name="Smallest_Length" runat="server" id="TextBoxSmallestFragmentLength" />
                    </div>
                    <div class="rc2">
                        <label for="TextBoxSmallestFragmentWidth" id="LabelSmallestFragmentWidth">Smallest Fragment Width (mm):</label>
                        <input type="text" name="Smallest_Width" runat="server" id="TextBoxSmallestFragmentWidth" />
                    </div>
                </div>
            </asp:Panel>

            <div class="clear-float"></div>
            <br />
            <br />

            <asp:Panel ID="PanelOtherDetails" runat="server" GroupingText="&nbsp;&nbsp;Other Details&nbsp;&nbsp;" Width="100%">
                <br />
                <div class="left-float">
                    <asp:Label runat="server" ID="LabelJointSpace" AssociatedControlID="DropDownListFragmentDocumented" Text="Fragment Documented:" />
                    <asp:DropDownList ID="DropDownListFragmentDocumented" runat="server" ToolTip="Fragment Documented, Select Yes or No" >
                        <asp:ListItem Text="Select a Value" />
                        <asp:ListItem Text="Yes" Value="true" />
                        <asp:ListItem Text="No" Value="false" />
                    </asp:DropDownList>
                </div>
                <div class="left-float">
                    <asp:Label runat="server" ID="LabelReviewed" AssociatedControlID="DropDownListReviewed" Text="Reviewed:" />
                    <asp:DropDownList ID="DropDownListReviewed" runat="server" ToolTip="Reviewed, Select Yes or No" >
                        <asp:ListItem Text="Select a Value" />
                        <asp:ListItem Text="Yes" Value="true" />
                        <asp:ListItem Text="No" Value="false" />
                    </asp:DropDownList>
                </div>
                <div class="left-float">
                    <asp:Label runat="server" ID="LabelIncludeInReport" AssociatedControlID="DropDownListIncludeInReport" Text="Include In Report:" />
                    <asp:DropDownList ID="DropDownListIncludeInReport" runat="server" ToolTip="Include In Report, Select Yes or No" >
                        <asp:ListItem Text="Select a Value" />
                        <asp:ListItem Text="Yes" Value="true" />
                        <asp:ListItem Text="No" Value="false" />
                    </asp:DropDownList>
                </div>
                <br />
                <br />
                <div class="left-float">
                    <asp:Label ID="LabelComments" runat="server" Text="Comments:" AssociatedControlID="TextBoxComments" />
                    <asp:TextBox ID="TextBoxComments" runat="server" MaxLength="2000" TextMode="MultiLine" Rows="5" ToolTip="Enter any general comments here" Width="1000" />
                </div>
            </asp:Panel>

        </div> 

    </div> 

    <br />
    <br />

    <asp:Table ID="tblSaveForm" runat="server">
        <asp:TableRow>
            <asp:TableCell>
                <asp:Button ID="ButtonSave" runat="server" Text="Save" OnClick="ButtonSave_Click" ToolTip="Select to save all settings." Width = "130px" />
            </asp:TableCell>
            <asp:TableCell>
                <asp:Button ID = "ButtonBack" runat="server" Text="Back" UseSubmitBehavior="true" CausesValidation="false" ToolTip="Return to Previous Page." Width = "130px" />
            </asp:TableCell>
        </asp:TableRow>
    </asp:Table>

</asp:Content>


